/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.info;

import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleMessage;
import filenet.sim.toolkit.console.images.VWSIMImageLoader;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class VWSIMMessageTableModel
extends AbstractTableModel {
    public static final int COLUMN_TYPE = 0;
    public static final int COLUMN_TIME = 1;
    public static final int COLUMN_MESSAGE = 2;
    private Vector m_rowData = null;
    private static final DateFormat m_dateTimeFormatter = DateFormat.getDateTimeInstance(3, 3);

    public VWSIMMessageTableModel(Vector rawData) {
        this.m_rowData = rawData;
    }

    public Class getColumnClass(int nColumnIndex) {
        if (nColumnIndex == 0) {
            return Icon.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return VWSIMResource.Time;
            }
            case 2: {
                return VWSIMResource.Message;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        block13: {
            try {
                VWSIMConsoleMessage aMessage = this.getRowItemAt(nRowIndex);
                if (aMessage != null) {
                    switch (nColumnIndex) {
                        case 0: {
                            int msgType = aMessage.getType();
                            ImageIcon aIcon = null;
                            switch (msgType) {
                                case 1: {
                                    aIcon = VWSIMImageLoader.createImageIcon("info_16.gif");
                                    break;
                                }
                                case 3: {
                                    aIcon = VWSIMImageLoader.createImageIcon("error_16.gif");
                                    break;
                                }
                                case 2: {
                                    aIcon = VWSIMImageLoader.createImageIcon("warning_16.gif");
                                }
                            }
                            return aIcon;
                        }
                        case 1: {
                            Date dt = aMessage.getDateTime();
                            return m_dateTimeFormatter.format(dt);
                        }
                        case 2: {
                            return aMessage.getMessage();
                        }
                    }
                    break block13;
                }
                return new String();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    public void removeRow(int rowId) {
        this.m_rowData.removeElementAt(rowId);
        this.fireTableRowsDeleted(rowId, rowId);
    }

    public void addRow(Object obj) {
        this.m_rowData.addElement(obj);
        int rowIndex = this.m_rowData.size() - 1;
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public void clearAll() {
        this.m_rowData.removeAllElements();
        this.fireTableDataChanged();
    }

    public VWSIMConsoleMessage getRowItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWSIMConsoleMessage)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    private String getCategory(VWSIMBaseNode aNode) {
        return "";
    }
}

